package com.agilex.healthcare.veteranappointment.restservice;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

import com.agilex.healthcare.veteranappointment.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.veteranappointment.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.veteranappointment.testutility.TestHelper;
import com.agilex.healthcare.veteranappointment.testutility.XpathHelper;


public class AppointmentMetadataTest {
	
	Document metadata = null;
	private static MobileHealthClientTestVersion client;
	
	@BeforeClass
	public static void startUp() {
		client = TestHelper.createMobileHealthClient();
	}
	
	@AfterClass
	public static void destroy() {
		if (client != null) {
			client.getJerseyClient().close();
			client = null;
		}
	}
	
	@Before
	public void getResourceAsXml() {
		String uriFormat = String.format("%s/appointment-service/metadata",
				IntegrationTestConfiguration.getMobileHealthServerBaseUri());
		URI uri = UriBuilder.fromUri(uriFormat).build();
		metadata = client.getJerseyClient().target(uri).request().accept("application/xml").get(Document.class);
	}
	
	@Test
	public void verifyAppointmentTypes(){
		verifyMetadata("//m:appointments-metadata/appointmentTypes");
	}
	
	@Test
	public void verifyBestTimetoCallOptions(){
		verifyMetadata("//m:appointments-metadata/bestTimetoCallOptions");
	}
	
	@Test
	public void verifyVisitTypes(){
		verifyMetadata("//m:appointments-metadata/visitTypes");
	}

	@Test
	public void verifyPurposeOfVisitOptions(){
		verifyMetadata("//m:appointments-metadata/purposeOfVisitOptions");
	}

	@Test
	public void verifyEarliestTimeVeteranCanRequestAppointmentInDaysIs3Days(){
		String minDaysXPath = "//m:appointments-metadata/earliestTimeVeteranCanRequestAppointmentInDays";
		verifyMetadata(minDaysXPath);
		String actualValue = XpathHelper.getString(metadata, minDaysXPath);
		assertEquals("4", actualValue);
	}

	@Test
	public void verifyFarthestTimeVeteranCanRequestAppointmentInDaysIs120Days(){
		String maxDaysXPath = "//m:appointments-metadata/farthestTimeVeteranCanRequestAppointmentInDays";
		verifyMetadata(maxDaysXPath);
		String actualValue = XpathHelper.getString(metadata, maxDaysXPath);
		assertEquals("120", actualValue);
	}

	@Test
	public void verifyDetailCodes(){
		verifyMetadata("//m:appointments-metadata/detailCodes");
	}
	
	@Test
	public void verifyAppointmentRequestStatusOptions(){
		verifyMetadata("//m:appointments-metadata/appointmentRequestStatusOptions");
	}

	@Test
	public void verifyAppointmentProcessedAsPerUserNeedOption(){
		verifyMetadata("//m:appointments-metadata/appointmentProcessedAsPerUserNeedOptions");
	}

	private void verifyMetadata(String metadataXpath) {
		Node node = XpathHelper.getNode(metadata, metadataXpath);
		assertNotNull(node);
	}
	
}
